state:filter_interactions(function(i)
  return "This level does not allow interaction."
end)

local sensor = resize.location.sensor
local node = resize.location.node
local pistons = resize.location.pistons
function is_wire_open()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialCreateWire"
end
function only_wire_filter(i)
  return i == PlayerInteraction.wire or i == PlayerInteraction.cancel
end

local default_vertical = -0.15
set_default_vertical(default_vertical)
function tutorial_routine()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu();
    state:suppress_transport_menu();
    state:suppress_interface_hints();
    set_user_input_filter(restrictive_filter)
    embed(announce("This factory already works.", 3, 0.1, captured_cancel()))
    embed(pause(0.2))
    embed(ramp(3, do_all(
      announce_lambda("It features a new block:", 0.06),
      announce_lambda("Nodes", 0.12, default_vertical - 0.1),
      glowing_box_at_game_lambda(node),
      bouncing_arrow_at_game_lambda(node, 0.06, LEFT),
      bouncing_arrow_at_game_lambda(node, 0.06, RIGHT),
      bouncing_arrow_at_game_lambda(node, 0.06, UP),
      bouncing_arrow_at_game_lambda(node, 0.06, DOWN)
    ), captured_cancel()))
    state:suppress_toolbar_menu(false);
    set_user_input_filter(only_wire_filter)
    embed(ramp_until(is_wire_open, do_all(
      announce_lambda("Open the wiring panel", 0.15),
      highlight_menu_item_lambda("toolbar_8")
    )))
    embed(announce("Nodes share whatever signals they receive.", 3, 0.1, captured_cancel()))
    embed(ramp(3, do_all(
      announce_lambda("When this sensor sees something...", 0.08),
      glowing_box_at_game_lambda(sensor),
      bouncing_arrow_at_game_lambda(sensor, 0.06, UP)
    ), captured_cancel()))
    embed(ramp(3, do_all(
      announce_lambda("...the node will activate...", 0.08),
      glowing_box_at_game_lambda(node),
      bouncing_arrow_at_game_lambda(node, 0.06, DOWN)
    ), captured_cancel()))
    embed(ramp(3, do_all(
      announce_lambda("...and actuate all the pistons.", 0.08),
      glowing_box_at_game_lambda(pistons),
      bouncing_arrow_at_game_lambda(pistons, 0.06, RIGHT)
    ), captured_cancel()))
    set_user_input_filter(only_play_or_speed_or_cancel_filter)
    embed(ramp_while(is_wire_open, do_all(
      announce_lambda("Right click far from a wire to close wiring panel.", 0.08),
      announce_lambda("(Or press Escape)", 0.06, default_vertical - 0.08)
    )))
    state:suppress_toolbar_menu();
    state:suppress_transport_menu(false);
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
  end)
end

draw_interpreted_routine(tutorial_routine())
